package zeiss.gesture.statusbar;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ImageView;
import android.widget.TextClock;
import android.widget.TextView;

/**
 * Created by dennis on 25/4/2017.
 */
public class StatusBarLauncherView extends StatusBarView<StatusBarLauncher> {
    private StatusBarLauncher mStatusBar;
    private StatusBarLauncher.LauncherHolder holder;
    public StatusBarLauncherView(Context context) {
        super(context);
    }

    public StatusBarLauncherView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public StatusBarLauncherView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public StatusBarLauncherView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public void init(Context context) {
        mStatusBar = new StatusBarLauncher(context);
        holder = mStatusBar.getHolder();
        addView(mStatusBar.getRootView());
    }

    @Override
    public StatusBarLauncher getStatusBar() {
        return mStatusBar;
    }

    public void onResume(){
        Log.i("StatusBarLauncherView","onResume");
        if(holder!=null) {
            holder.onResume();
        }
    }


    public void onPause() {
        Log.i("StatusBarLauncherView","onPause");
        if(holder!=null) {
            holder.onPause();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Log.i("StatusBarLauncherView","onDetachedFromWindow");
        if(holder!=null) {
            holder.onDestory();
        }
    }
}
