package zeiss.gesture.view;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import java.util.ArrayList;

import zeiss.gesture.model.WheelViewItem;

/**
 * Created by williamzhang on 2/9/16.
 */
public class DefaultWheelView<T> extends WheelView<String> {


    private int selectedTextColor = Color.BLACK;
    private int unselectedTextColor = Color.WHITE;
    private Context mContext;
    private boolean showIndexNumOnRow = false;
    private int lineHeight = 70;
    private int leftMargin = 30;

    public DefaultWheelView(Context context) {
        super(context);
    }

    public DefaultWheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setContext(Context context) {
        mContext = context;
    }

    public int getSelectedTextColor() {
        return selectedTextColor;
    }

    public void setSelectedTextColor(int selectedTextColor) {
        this.selectedTextColor = selectedTextColor;
    }

    public int getUnselectedTextColor() {
        return unselectedTextColor;
    }

    public void setUnselectedTextColor(int unselectedTextColor) {
        this.unselectedTextColor = unselectedTextColor;
    }

    public void setShowIndexNumOnRow(boolean bool){
        showIndexNumOnRow = bool;
    }


    public void setLineHeight(int lineHeight) {
        this.lineHeight = lineHeight;
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    @Override
    public void commit() {
        initial();
        super.commit();
    }

    public void initial() {
        setOnWheelViewInterface(new WheelView.WheelViewInteface<String>() {
            @Override
            public View onCreateItemView(String item, int index) {

                // Creating a new TextView
                TextView tv = new TextView(mContext);
                tv.setTag(index);
                if (showIndexNumOnRow) {
                    tv.setText((index + 1) + ". " + item);
                } else {
                    tv.setText(item);
                }
                tv.setTextColor(unselectedTextColor);
                tv.setTextSize(getTextSize());
                tv.setGravity(Gravity.CENTER_VERTICAL);
                // Defining the layout parameters of the TextView
                RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(
                        RelativeLayout.LayoutParams.MATCH_PARENT,
                        RelativeLayout.LayoutParams.MATCH_PARENT);
                lp.setMargins(leftMargin, 0, 0, 0);
                // Setting the parameters on the TextView
                tv.setLayoutParams(lp);

                return new WheelViewItem(mContext, tv, lineHeight);
            }
        });
    }

    @Override
    public void setOnWheelViewListener(OnWheelViewListener<String> onWheelViewListener) {
        super.setOnWheelViewListener(new WheelView.OnWheelViewListener<String>() {
            @Override
            public void onSelected(int selectedIndex, String item) {
//                Log("selectedIndex = " + selectedIndex + " item = " + item);
            }

            @Override
            public void onScrollItemChanged(int previousIndex, int selectedIndex, String item, ArrayList<View> itemList) {
                TextView previousTextView = (TextView) (itemList.get(previousIndex)).findViewWithTag(previousIndex);
                //color of not selected text
                previousTextView.setTextColor(getUnselectedTextColor());
                previousTextView.setTextSize(TypedValue.COMPLEX_UNIT_SP, getTextSize());
                previousTextView.setSelected(false);

                TextView selectedTextView = (TextView) (itemList.get(selectedIndex)).findViewWithTag(selectedIndex);
                //color of selected text
                selectedTextView.setTextColor(getSelectedTextColor());
                selectedTextView.setTextSize(TypedValue.COMPLEX_UNIT_SP, getTextSize());
                selectedTextView.setSelected(true);
//                selectedTextView.bringToFront();
            }

        });

    }

}
