package zeiss.gesture.view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Scroller;

import zeiss.gesture.R;
import zeiss.gesture.Util;
import zeiss.gesture.adapter.WheelviewAdapter;
import zeiss.gesture.detector.ZeissGestureTouchDetector;
import zeiss.gesture.statusbar.StatusBarApp;
import zeiss.gesture.statusbar.StatusBarAppView;
import zeiss.gesture.statusbar.util.DividerItemDecoration;


public class WheelViewRecyclerView extends RelativeLayout implements ZeissGestureTouchDetector.OnScrollListener {
    public interface OnWheelViewListener2 {
        void onScrollStart(int selectedIndex);
        void onSelected(int selectedIndex);

        void onScrollItemChanged(int previousIndex, int selectedIndex);
    }
    public interface OnWheelViewListener {

        void onSelected(int selectedIndex);

        void onScrollItemChanged(int previousIndex, int selectedIndex);
    }
    public static final String TAG = WheelViewRecyclerView.class.getSimpleName();

    private static int MAX_FLING = 9999;
    private static int FLING_FACTOR = 300;
    private static int DEFAULT_ITEM_HEIGHT = 50;
    private static int DEFAULT_DISPLAY_ITEM = 99;
    private static int DEFAULT_SCROLL_SWIPE_X_RANGE = 5;

    private Context context;
    private View selectedView;

    private int layoutHeight, layoutWidth;

    int displayItemCount = DEFAULT_DISPLAY_ITEM;
    private int reqSelectItemPosition = 0;
    private int selectedIndex = 0;
    private int previousSelectedIndex = 0;
    int itemHeight = 0;
    int flingY;

    private int mSelectedViewPosition;

    private OnWheelViewListener mOnWheelViewListener;
    private OnWheelViewListener2 mOnWheelViewListener2;

    private MyLayoutManager mMyLayoutManager;
    private RecyclerView mRecyclerView;
    private WheelviewAdapter mAdapter;
    int displayHeight;

    private static final int DIRECTION_UP = -1;
    private static final int DIRECTION_DOWN = 1;
    public enum SCROLL_DIRECTION{
        DIRECTION_UP,DIRECTION_DOWN
    }
    private SCROLL_DIRECTION direction = SCROLL_DIRECTION.DIRECTION_DOWN;

    private ScrollHandler mScrollHandler;

    private boolean isHiddenSelectedView;
    private boolean isRunning;

    private boolean isScrolStart;
    private StatusBarAppView mStatusBarAppView;
    private StatusBarApp mStatusBar;
    private RelativeLayout mHeaderView;
    @Override
    public void requestLayout() {
        super.requestLayout();
        Log("WheelViewRecyclerView:requestLayout");
    }

    @Override
    public void invalidate() {
        super.invalidate();
        Log("WheelViewRecyclerView:requestLayout");
    }

    public void setDirection(SCROLL_DIRECTION direction) {
        this.direction = direction;
    }

    public RecyclerView getRecyclerView() {
        return mRecyclerView;
    }
    public void setAdapter(WheelviewAdapter adapter) {
        if(mAdapter == null) {
            tempHide(false);
        }else{
            this.selectedIndex = -1;
            tempHide(true);
        }
        this.mAdapter = adapter;
        this.mRecyclerView.setAdapter(adapter);
    }
    public WheelviewAdapter getAdapter() {
        return mAdapter;
    }

    public WheelViewRecyclerView(Context context) {
        super(context);
        init(context);

    }

    public WheelViewRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public WheelViewRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init(context);
    }
    public void commit() {
        initData();
    }

    private void init(Context context) {
        this.isRunning = false;
        this.isHiddenSelectedView = false;
        this.context = context;

        this.mScrollHandler = new ScrollHandler();
        View customRecyclerViewGroup = LayoutInflater.from(context).inflate(R.layout.custom_recyclerview, null);
        this.mRecyclerView = (RecyclerView) customRecyclerViewGroup.findViewById(R.id.recyclerView);
        //this.mRecyclerView = new RecyclerView(context);
        this.mRecyclerView.setHasFixedSize(false);
        try {
            this.mRecyclerView.getItemAnimator().setSupportsChangeAnimations(false);
            this.mRecyclerView.setDescendantFocusability(RecyclerView.FOCUS_BLOCK_DESCENDANTS);
        }catch (Exception e){
            Log("setSupportsChangeAnimations -- e ="+e.toString());
        }

        this.itemHeight = DEFAULT_ITEM_HEIGHT;
        this.mMyLayoutManager = new MyLayoutManager(context);
        this.mMyLayoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        this.mRecyclerView.setLayoutManager(mMyLayoutManager);

        this.selectedView = new View(context);

        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(LinearLayout.VERTICAL);

        RelativeLayout relativeLayout = new RelativeLayout(context);
        relativeLayout.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,ViewGroup.LayoutParams.MATCH_PARENT));
//        relativeLayout.setBackgroundColor(Color.YELLOW);
        mHeaderView = new RelativeLayout(context);
        addView(linearLayout);
        relativeLayout.addView(selectedView);
        relativeLayout.addView(mRecyclerView);

        linearLayout.addView(mHeaderView);
        linearLayout.addView(relativeLayout);

//        addView(selectedView);
//        addView(mRecyclerView);

        //setSelectedViewColor(Color.parseColor("#CCFFFFFF"));

        setSelectedViewColor(ContextCompat.getColor(context, R.color.color_default_highlight_blue));

        onFlingRunnable = new OnFlingRunnable(context, new OnFlingRunnable.Callback() {
            @Override
            public void started() {
                mScrollHandler.removeMessages(MOVE_END);
                Log("OnFlingRunnable -- started");
            }

            @Override
            public void update(int position) {
//                Log("OnFlingRunnable -- update : " + position);
                scrollViewBy(position);
            }

            @Override
            public void stopped() {
                Log("OnFlingRunnable -- stopped");
//                selectItem(selectedIndex);
//                onSelectedCallBack();

                mScrollHandler.sendEmptyMessageDelayed(MOVE_END,DELAYTIME_MOVE_END);
            }
        });

        selectItem(0);

        mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
            }

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                Log("onScrolled dx = "+dx+" dy = "+dy);
            }
        });


    }

    private void initData() {
        onScrollChanged(previousSelectedIndex, selectedIndex);
    }
    private  void tempHide(boolean isHide){
        if(isHide || isHiddenSelectedView) {
            selectedView.setVisibility(View.INVISIBLE);
        }else{
            selectedView.setVisibility(View.VISIBLE);
        }
}
    public void setHiddenSelectedView(boolean isHide){
        isHiddenSelectedView = isHide;
        if(isHiddenSelectedView){
            selectedView.setVisibility(View.INVISIBLE);
        }else{
            selectedView.setVisibility(View.VISIBLE);
        }
    }

    private int getDirection(){
        switch (direction) {
            case DIRECTION_UP:
                return DIRECTION_UP;
            case DIRECTION_DOWN:
                return DIRECTION_DOWN;
        }
        return DIRECTION_UP;
    }
    private void scrollViewBy(float y) {
        Log("WVRV: scrollViewBy :  Y = "+y+" selectedView.getY() = "+selectedView.getY()+" mRecyclerView.computeVerticalScrollOffset() = "+mRecyclerView.computeVerticalScrollOffset());
        isRunning = true;
        scrollViewTo((int)selectedView.getY() + mRecyclerView.computeVerticalScrollOffset()  - ((int) y * getDirection()));
    }

    private void scrollViewTo(final int newPositionY) {
        float totalHeigh,centerY,canMoveY,lastPositionY;
        if(mRecyclerView.getAdapter()!=null) {
            totalHeigh = itemHeight * mRecyclerView.getAdapter().getItemCount();
        }else{
            totalHeigh = 0;
        }
        centerY = displayHeight / 2 - itemHeight / 2;
        canMoveY = totalHeigh - displayHeight;
        if(canMoveY < 0 && totalHeigh > centerY){
            lastPositionY = centerY;
        }else if(canMoveY < 0 && totalHeigh < centerY){
            lastPositionY = totalHeigh - itemHeight;
        }else {
            lastPositionY = canMoveY + centerY;
        }

        int currentPosY = newPositionY;
        if (currentPosY > lastPositionY) {
//            mMyLayoutManager.scrollToPositionWithOffset(mRecyclerView.getAdapter().getItemCount()-1,0);
            mRecyclerView.scrollBy(0,  (int)(totalHeigh - mRecyclerView.computeVerticalScrollOffset()));
            Log("WVRV: scrollViewTo:case1 -- currentPosY > lastPositionY : mRecyclerView.computeVerticalScrollOffset() = "+mRecyclerView.computeVerticalScrollOffset()+ " currentPosY = "+currentPosY+" lastPositionY = " +lastPositionY+" displayHeight = "+displayHeight);
        } else if (currentPosY < centerY) {
            Log("WVRV: scrollViewTo:case2 -- currentPosY < centerY : mRecyclerView.computeVerticalScrollOffset()"+mRecyclerView.computeVerticalScrollOffset()+" currentPosY = "+currentPosY+" lastPositionY " +lastPositionY);
            mRecyclerView.scrollBy(0, -mRecyclerView.computeVerticalScrollOffset());
//            mMyLayoutManager.scrollToPositionWithOffset(0,0);
        } else {
            int position = (int)((currentPosY - centerY)/(float)itemHeight);
            int offest = ((int)(currentPosY - centerY) - (position * itemHeight));
            if(offest == 0){
                mRecyclerView.smoothScrollToPosition(position);
            }else {
                Log("WVRV: scrollViewTo:case3 currentPosY = "+currentPosY+" centerY = "+centerY+" (currentPosY - centerY) = "+(int)(currentPosY - centerY)+" mRecyclerView.computeVerticalScrollOffset() = "+mRecyclerView.computeVerticalScrollOffset()+" result = "+((int)(currentPosY - centerY) - mRecyclerView.computeVerticalScrollOffset()));
                mRecyclerView.scrollBy(0,  (int)(currentPosY - centerY) - mRecyclerView.computeVerticalScrollOffset());
//                mMyLayoutManager.scrollToPositionWithOffset(position, offest * -1);
            }
//            Log("scrollViewTo : position = "+position+" offest =  "+offest+" newPositionY = "+newPositionY);
        }
//        Log("scrollViewTo : currentPosY = "+currentPosY+" lastPositionY = "+lastPositionY+" centerY "+centerY+" newPositionY = "+newPositionY);
        mSelectedViewPosition = newPositionY;
        removeCallbacks(mSelectedViewRunnable);
        post(mSelectedViewRunnable);
    }

    private void updateSelectedView(int newPositionY,int verticalScrollOffset) {
        float positionHeight = 0;
        float totalHeigh,centerY,canMoveY,lastPositionY;
        if(mRecyclerView.getAdapter()!=null) {
            totalHeigh = itemHeight * mRecyclerView.getAdapter().getItemCount();
        }else{
            totalHeigh = 0;
        }
        centerY = displayHeight / 2 - itemHeight / 2;
        canMoveY = totalHeigh - displayHeight;
        if(canMoveY < 0 && totalHeigh - itemHeight > centerY){
            lastPositionY = centerY;
        }else if(canMoveY < 0 && totalHeigh - itemHeight < centerY){
            lastPositionY = totalHeigh - itemHeight;
        }else {
            lastPositionY = canMoveY + centerY;
        }

        int currentPosY = newPositionY;

        //Log("verticalScrollOffset = "+verticalScrollOffset);
        //Log("updateSelectedView totalHeigh  = "+totalHeigh +" centerY = "+centerY+" canMoveY = "+canMoveY+" lastPositionY = "+lastPositionY+" newPositionY = "+newPositionY+" itemHeight = "+itemHeight);
        if(totalHeigh <= 0){
            selectedView.setY(-itemHeight);
        }else if (currentPosY > lastPositionY) {
            if(canMoveY<0 && newPositionY > totalHeigh - itemHeight){
                selectedView.setY(totalHeigh - itemHeight);
            }else if (newPositionY - verticalScrollOffset >= displayHeight - itemHeight) {
                selectedView.setY(displayHeight - itemHeight);
            } else {
                selectedView.setY(newPositionY - verticalScrollOffset);
            }
        } else if (currentPosY < centerY) {
            if (currentPosY < 0) {
                selectedView.setY(0);
            } else {
                selectedView.setY(newPositionY - verticalScrollOffset);
            }
        } else {
            selectedView.setY(centerY);
        }

        positionHeight = Math.min(totalHeigh - itemHeight,newPositionY + itemHeight / 2);

        int index = (int) (positionHeight / itemHeight);
        if(index<0){
            index = 0;
        }
        previousSelectedIndex = selectedIndex;
        if(index != selectedIndex){
            onScrollChanged(previousSelectedIndex, index);

            if (onFlingRunnable != null) {
                if(mRecyclerView.getAdapter()!=null
                        && (index == 0 || index == mRecyclerView.getAdapter().getItemCount() - 1)) {
                    onFlingRunnable.stop();
                    onFlingRunnable.onFinish();
                }
            }

        }
        selectedIndex = index;
        tempHide(false);

        isRunning = false;
        Log("WVRV: updateSelectedView selectedIndex  = "+selectedIndex+" selectedView.getY() = "+selectedView.getY() +" positionHeight = "+positionHeight+" itemHeight = "+itemHeight+" newPositionY= "+newPositionY+" verticalScrollOffset = "+verticalScrollOffset);
    }

    public int getSelectedIndex(){
        return selectedIndex;
    }

    private void touchMoveEnd(){
        if(previousSelectedIndex!=selectedIndex) {
            onScrollChanged(previousSelectedIndex, selectedIndex);
        }
        removeCallbacks(mScrollEndRunnable);
        post(mScrollEndRunnable);

    }

    public void selectItem(final int position) {
        if(mRecyclerView.getAdapter()!=null) {
            reqSelectItemPosition = position;
            removeCallbacks(mScrollRunnable);
            post(mScrollRunnable);
        }
    }

    private void onSelectedCallBack() {
        if (null != mOnWheelViewListener) {
            mOnWheelViewListener.onSelected(selectedIndex);
        }

        if(mOnWheelViewListener2 != null){
            mOnWheelViewListener2.onSelected(selectedIndex);
        }
    }

    private void onScrollChanged(int previousSelectedIndex, int index) {
        if(mOnWheelViewListener!=null) {
            mOnWheelViewListener.onScrollItemChanged(previousSelectedIndex, index);
        }

        if(mOnWheelViewListener2!=null){
            mOnWheelViewListener2.onScrollItemChanged(previousSelectedIndex,index);
        }
    }

    public void setOnWheelViewListener(OnWheelViewListener onWheelViewListener) {
        this.mOnWheelViewListener   = onWheelViewListener;
    }
    public void setOnWheelViewListener2(OnWheelViewListener2 onWheelViewListener2) {
        this.mOnWheelViewListener2   = onWheelViewListener2;
    }
//
//    public void setOnWheelViewInterface(WheelViewInteface onWheelViewInteface) {
//        this.onWheelViewInteface = onWheelViewInteface;
//    }

    private int dip2px(float dpValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (dpValue * scale + 0.5f);
    }

    private int getViewMeasuredHeight(View view) {
        int width = MeasureSpec.makeMeasureSpec(0, MeasureSpec.UNSPECIFIED);
        int expandSpec = MeasureSpec.makeMeasureSpec(Integer.MAX_VALUE >> 2, MeasureSpec.AT_MOST);
        view.measure(width, expandSpec);
        return view.getMeasuredHeight();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {

        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        //setMeasuredDimension(MeasureSpec.getSize(widthMeasureSpec), MeasureSpec.getSize(heightMeasureSpec));
        int newLayoutHeight = MeasureSpec.getSize(heightMeasureSpec);
        int newLayoutWidth = MeasureSpec.getSize(widthMeasureSpec);
//        int newLayoutHeight = widthMeasureSpec;
//        int newLayoutWidth = heightMeasureSpec;
        Log("onMeasure:1 newLayoutHeight = "+newLayoutHeight+" newLayoutWidth = "+newLayoutWidth +" mHeaderView.getHeight() = "+mHeaderView.getHeight());
        if (newLayoutHeight - mHeaderView.getHeight() != layoutHeight  || newLayoutWidth != layoutWidth) {
            layoutHeight = newLayoutHeight - mHeaderView.getHeight();
            layoutWidth = newLayoutWidth;
            onMeasureUpdateLayoutSize();
        }
    }

    private void onMeasureUpdateLayoutSize() {
        Log("onMeasure:2 onMeasureUpdateLayoutSize layoutHeight = "+layoutHeight+" layoutWidth = "+layoutWidth);
        if(layoutHeight!=0 && layoutWidth!=0) {
            if(mAdapter!=null) {
                itemHeight = mAdapter.getItemHeight();
            }else {
                itemHeight = mMyLayoutManager.getLayoutHeight();
            }
            displayHeight = itemHeight * displayItemCount;
            if (displayHeight > layoutHeight) {
                mRecyclerView.getLayoutParams().height = layoutHeight;
                displayHeight = layoutHeight;
            } else {
                mRecyclerView.getLayoutParams().height = displayHeight;
            }

            //getLayoutParams().width = layoutWidth;
//            getLayoutParams().height = layoutHeight;

            selectedView.setLayoutParams(new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, itemHeight));
            Log("onMeasure:3 onMeasureUpdateLayoutSize itemHeight = " + itemHeight + " displayHeight = " + displayHeight + " layoutHeight = " + layoutHeight);
        }
    }

    public void setSelectedViewColor(int color) {
        selectedView.setBackgroundColor(color);
    }

    public void setSelectedViewBackgroundResource(int id){
        selectedView.setBackgroundResource(id);
    }

    public void setDisplayItemCount(int displayItemCount) {
        this.displayItemCount = displayItemCount;
    }

    public void scrollToTop() {
        selectItem(0);
    }

    public void scrollToBottom() {
        selectItem(getRecyclerView().getAdapter().getItemCount()-1);
    }

    private void Log(String msg) {
        if(Util.DEBUG) {
            Log.i(TAG, msg);
        }
    }

    @Override
    public void onStart(MotionEvent event) {
        if(mRecyclerView!=null && mRecyclerView.getAdapter()!=null) {
            isScrolStart = true;
            onFlingRunnable.stop();
        }
    }

    @Override
    public void onMove(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY, boolean isDrag) {
        if(mRecyclerView!=null && mRecyclerView.getAdapter()!=null) {
            //if (isDrag && distanceY != 0 && !isRunning) {
            Log("distanceX = "+distanceX+" distanceY = "+distanceY+" isDrag = "+isDrag);

            if (isDrag && distanceY != 0 && Math.abs(distanceX) < DEFAULT_SCROLL_SWIPE_X_RANGE) {
                if(isScrolStart){
                    isScrolStart = false;
                    if(mOnWheelViewListener2!=null) {
                        mOnWheelViewListener2.onScrollStart(selectedIndex);
                    }
                }
                mScrollHandler.removeMessages(MOVE_END);
                scrollViewBy(distanceY);
            }
        }
    }

    @Override
    public void onMoveEnd(MotionEvent event) {
        isScrolStart = false;
        if(mRecyclerView!=null && mRecyclerView.getAdapter()!=null) {
            mScrollHandler.sendEmptyMessageDelayed(MOVE_END, DELAYTIME_MOVE_END);
        }
//            touchMoveEnd();
//            onSelectedCallBack();
    }

    @Override
    public void onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {

        flingY = (int) (velocityY * -1) / 2;
        Log("onFling OnFlingRunnable = "+flingY+" selectedIndex = "+selectedIndex +" previousSelectedIndex = "+previousSelectedIndex);
        onFlingRunnable.onFling(flingY);
//        if(getDirection() == DIRECTION_UP){
//            if(flingY > 0) {
//                onFlingRunnable.onFling(Math.min(flingY,(mRecyclerView.getAdapter().getItemCount() - previousSelectedIndex) * FLING_FACTOR));
//            }else{
//                onFlingRunnable.onFling(Math.max(flingY,previousSelectedIndex * FLING_FACTOR * -1));
//            }
//        }else{
//            if(flingY > 0) {
//                onFlingRunnable.onFling(Math.min(flingY, previousSelectedIndex * FLING_FACTOR));
//            }else{
//                onFlingRunnable.onFling(Math.max(flingY, ((mRecyclerView.getAdapter().getItemCount() - previousSelectedIndex) * FLING_FACTOR)* -1));
//            }
//        }
        onFlingRunnable.start();
    }


    private OnFlingRunnable onFlingRunnable;

    public static class OnFlingRunnable implements Runnable {
        interface Callback {
            void started();

            void update(int position);

            void stopped();
        }

        private static final int DELAY_MILLIS = 0;
        private Callback mCallback;
        private int mPreviousPosition;
        private Scroller mScroller;
        private Handler handler;
        private boolean isStart;

        public boolean isStart() {
            return isStart;
        }

        public OnFlingRunnable(Context context, Callback callback) {
            handler = new Handler();
            mCallback = callback;
            mScroller = new Scroller(context, new AccelerateDecelerateInterpolator());
            isStart = false;
        }

        void start() {
//            Log.e("AAA", "start OnFlingRunnable");
            isStart = true;
            mPreviousPosition = 0;
            handler.postDelayed(this, DELAY_MILLIS);
        }

        void stop() {
            mPreviousPosition = 0;
            handler.removeCallbacks(this);
            isStart = false;
        }
        void onFinish(){
            mCallback.stopped();
        }

        void onFling(int y) {
            Log.e("AAA", "onFling OnFlingRunnable -- y = " + (y));
            mScroller.fling(0, 0, 0, y,
                    Integer.MIN_VALUE,
                    Integer.MAX_VALUE,
                    Integer.MIN_VALUE,
                    Integer.MAX_VALUE);

//            Log.e("AAA", "OnFlingRunnable -- onFling : getCurrY = " + mScroller.getCurrY() + " getFinalY = " + mScroller.getFinalY() + " getStartY = " + mScroller.getStartY());
        }


        @Override
        public void run() {
            mScroller.computeScrollOffset();
            int position = mScroller.getCurrY();
            if (mPreviousPosition - position == 0) {
                stop();
                onFinish();
            } else {
                if (mPreviousPosition == 0) {
                    mCallback.started();
                } else {
//                        Log.e("AAA","OnFlingRunnable -- diff = "+(position - mPreviousPosition));
                    mCallback.update(position - mPreviousPosition);
                }
                mPreviousPosition = mScroller.getCurrY();
                handler.postDelayed(this, DELAY_MILLIS);
            }
        }
    }
    private Runnable mScrollByRunnable = new Runnable() {
        @Override
        public void run() {
            updateSelectedView(mSelectedViewPosition, mMyLayoutManager.getScrollY());
        }
    };
    private Runnable mSelectedViewRunnable = new Runnable() {
        @Override
        public void run() {
            Log("WVRV: mSelectedViewRunnable");
            updateSelectedView(mSelectedViewPosition, mMyLayoutManager.getScrollY());
        }
    };
    private Runnable mScrollEndRunnable = new Runnable() {
        @Override
        public void run() {
            Log("WVRV: mScrollEndRunnable");
            scrollViewTo(itemHeight * selectedIndex);
            onSelectedCallBack();
//            onScrollChanged(previousSelectedIndex, selectedIndex);
        }
    };
    private Runnable mScrollRunnable = new Runnable() {
        @Override
        public void run() {
            Log("WVRV: mScrollRunnable");
            scrollViewTo(itemHeight * reqSelectItemPosition);
            onSelectedCallBack();
//            onScrollChanged(previousSelectedIndex, reqSelectItemPosition);
        }
    };

    public void onResume() {

    }


    public void onStop() {
        if (onFlingRunnable != null && onFlingRunnable.isStart()) {
            onFlingRunnable.stop();
        }
    }

    public void onDestroy(){
        removeCallbacks(mScrollEndRunnable);
        removeCallbacks(mScrollRunnable);
        removeCallbacks(mSelectedViewRunnable);
        if(mScrollHandler!=null) {
            mScrollHandler.removeCallbacksAndMessages(null);
        }
    }

    public  static class MyLayoutManager extends LinearLayoutManager {
        private static final float MILLISECONDS_PER_INCH = 50f;
        private Context mContext;
        private int layoutHeight;
        private int layoutWidth;

        public int getLayoutHeight() {
            return layoutHeight;
        }

        public int getLayoutWidth() {
            return layoutWidth;
        }

        public MyLayoutManager(Context context) {
            super(context);
            mContext = context;
            // TODO Auto-generated constructor stub
            // setAutoMeasureEnabled(false);
        }

        @Override
        public void smoothScrollToPosition(RecyclerView recyclerView,
                                           RecyclerView.State state, int position) {
            //Create your RecyclerView.SmoothScroller instance? Check.
            LinearSmoothScroller smoothScroller =
                    new LinearSmoothScroller(mContext) {
                        //Automatically implements this method on instantiation.
                        @Override
                        public PointF computeScrollVectorForPosition
                        (int targetPosition) {
                            return MyLayoutManager.this
                                    .computeScrollVectorForPosition(targetPosition);
                        }
                        @Override
                        protected float calculateSpeedPerPixel
                                (DisplayMetrics displayMetrics) {
                            return MILLISECONDS_PER_INCH/displayMetrics.densityDpi;
                        }
                    };

            //Docs do not tell us anything about this,
            //but we need to set the position we want to scroll to.
            smoothScroller.setTargetPosition(position);

            //Call startSmoothScroll(SmoothScroller)? Check.
            startSmoothScroll(smoothScroller);
        }


        @Override
        public void onMeasure(RecyclerView.Recycler recycler, RecyclerView.State state, int widthSpec, int heightSpec) {
            super.onMeasure(recycler,state,widthSpec,heightSpec);

            if (state!=null && state.getItemCount() > 0) {
                View view = recycler.getViewForPosition(0);
                if (view != null) {
                    measureChild(view, widthSpec, heightSpec);
                    int measuredWidth = MeasureSpec.getSize(widthSpec);
                    int measuredHeight = MeasureSpec.getSize(heightSpec);
                    int viewHeight = view.getMeasuredHeight();
                    int viewWidth = view.getMeasuredWidth();
                    setMeasuredDimension(measuredWidth, measuredHeight);
                    this.layoutHeight = viewHeight;
                    this.layoutWidth = viewWidth;
                }
            }
        }

        public int getScrollY() {
            int position = findFirstVisibleItemPosition();
            View firstVisiableChildView = findViewByPosition(position);
            if(firstVisiableChildView!=null) {
                int itemHeight = firstVisiableChildView.getHeight();
                return (position) * itemHeight - firstVisiableChildView.getTop();
            }else{
                return 0;
            }
        }

    }
    public final static long DELAYTIME_MOVE_END = 100;
    public final static int MOVE_END = 1;
    private class ScrollHandler extends Handler {

        ScrollHandler() {
            super();
        }

        ScrollHandler(Handler handler) {
            super(handler.getLooper());
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case MOVE_END:
                    Log("ScrollHandler MOVE_END");
                    touchMoveEnd();
                    break;
                default:
                    throw new RuntimeException("Unknown message " + msg); // never
            }
        }
    }


    public boolean selectNextItem() {
        //Preventing index out of bounds
        if (getSelectedIndex() < getAdapter().getItemCount()) {
            selectItem(getSelectedIndex() + 1);
            return true;
        }
        return false;
    }

    public boolean selectPreviousItem() {
        //Preventing index out of bounds
        if (getSelectedIndex() > 0) {
            selectItem(getSelectedIndex() - 1);
            return true;
        }
        return false;

    }

    public void removeStatusBar(){
        if(mHeaderView!=null) {
            mHeaderView.removeAllViews();
        }

        if(mStatusBarAppView!=null) {
            mStatusBar.getRootView().removeAllViews();
            mStatusBar = null;
            mStatusBarAppView = null;
        }

    }
    public StatusBarApp createStatusBar(){
        if(mStatusBar==null) {
            mStatusBarAppView = new StatusBarAppView(getContext());
            mStatusBar = mStatusBarAppView.getStatusBar();
            mHeaderView.removeAllViews();
            mHeaderView.addView(mStatusBarAppView);
        }
        return mStatusBar;
    }


    public void setDivider(){
//        getRecyclerView().addItemDecoration(
//                new DividerItemDecoration(getContext(), null));
    }
    public void setDivider(Drawable drawable){
//        getRecyclerView().addItemDecoration(
//                new DividerItemDecoration(getContext(),drawable,null));
    }



}
