package zeiss.gesture;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.util.Log;

/**
 * Created by dennis on 22/9/16.
 */
public class Util {
    private static String TAG = Util.class.getSimpleName();
    public static boolean DEBUG = false;

    /**
     * TRUE == OFF ROM SystemGesture (back and home)
     * FALSE == ON ROM SystemGesture (back and home)
     * @param context
     * @param isEnalbe
     */
    public static void EnableSystemGesture(Context context,boolean isEnalbe){

        SharedPreferences mySharedPreferences= context.getSharedPreferences("touch", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = mySharedPreferences.edit();
        editor.putString("touchevent", isEnalbe?"true":"false");
        editor.commit();

        Log.e("Util","EnableSystemGesture touchevent: = "+isEnalbe);
//        String touch_boolean123=SystemProperties.get("persist.touch_event123", "false");   //xiong 2016.09.29
//        String key = "persist.touch_event";
//        String val = isEnalbe?"true":"false";
//        SystemProperties.set(key,val);
        //Log.e("Util","SystemProperties: result = "+result);

    }

    /**
     * FALSE == OFF ROM EnableGestureInAllApp (back and home)
     * TRUE == ON ROM EnableGestureInAllApp (back and home)
     */
    public static void EnableGestureInAllApp(boolean isEnable){
        String key = "persist.touch_event123";
        String val = isEnable?"true":"false";

        SystemProperties.set(key,val);
        String result = SystemProperties.get("persist.touch_event123","false");
        Log.e("EnableGestureInAllApp","result = "+result);
    }

    public static boolean AppInstalledOrNot(Context context, String uri) {
        PackageManager pm = context.getPackageManager();
        boolean app_installed;
        try {
            pm.getPackageInfo(uri, PackageManager.GET_ACTIVITIES);
            app_installed = true;
        }
        catch (PackageManager.NameNotFoundException e) {
            app_installed = false;
        }
        return app_installed;
    }

}
