package zeiss.gesture.activity;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import zeiss.gesture.view.ZeissGestureView;

/**
 * Created by dennis on 30/9/16.
 */
public abstract class ZeissGestureActivity extends Activity{
    private RelativeLayout mTopLayout, mBottomLayout;
    private ZeissGestureView mZeissGestureView;
    @Override
    public void setContentView(View view) {
        View v = createGestureView(view);
        super.setContentView(v);
    }

    @Override
    public void setContentView(int layoutResID) {
        View child = getLayoutInflater().inflate(layoutResID, null);
        View v = createGestureView(child);
        super.setContentView(v);
    }

    @Override
    public void setContentView(View view, ViewGroup.LayoutParams params) {
        View v = createGestureView(view);
        super.setContentView(v);
    }

    private View createGestureView(View view){
        RelativeLayout root = new RelativeLayout(this);

        mTopLayout = new RelativeLayout(this);
        mBottomLayout = new RelativeLayout(this);

        mZeissGestureView = new ZeissGestureView(this){
            @Override
            public void onBackPress() {
                super.onBackPress();
            }

            @Override
            public void onHomePress() {
                super.onHomePress();
            }
        };
//        mZeissGestureView.commit();

        mBottomLayout.addView(view);
        mTopLayout.addView(mZeissGestureView);

        root.addView(mBottomLayout);
        root.addView(mTopLayout);

        return root;
    }


    public RelativeLayout getTopLayout() {
        return mTopLayout;
    }

    public RelativeLayout getBottomLayout() {
        return mBottomLayout;
    }

    public ZeissGestureView getZeissGestureView() {
        return mZeissGestureView;
    }
}
