package zeiss.gesture.adapter;

import android.content.Context;
import android.graphics.Color;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.List;

import zeiss.gesture.model.WheelViewItem;

/**
 * Created by dennis on 20/9/16.
 */
public class DefaultWheelviewAdapter extends  WheelviewAdapter<DefaultWheelviewAdapter.ViewHolder> {
    List<Contact> mContacts;
    private int selectedTextColor = Color.BLACK;
    private int unselectedTextColor = Color.WHITE;
    private int leftMargin = 30;
    private int textSize = 20;

    public DefaultWheelviewAdapter(int itemHeight,List<Contact> contacts) {
        super(itemHeight);
        mContacts = contacts;
        if(mContacts == null){
            mContacts=  new ArrayList<Contact>();
        }
    }


    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        Log.i("TAG","onCreateViewHolder");
        Context context = parent.getContext();

        TextView tv = new TextView(context);
        tv.setTag(ViewHolder.TAG_NAME);
//        tv.setTextColor(unselectedTextColor);
//        tv.setTextSize(textSize);
//        tv.setGravity(Gravity.CENTER_VERTICAL);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(
                RelativeLayout.LayoutParams.MATCH_PARENT,
                RelativeLayout.LayoutParams.MATCH_PARENT);
        lp.setMargins(leftMargin, 0, 0, 0);
        tv.setLayoutParams(lp);

        ViewHolder viewHolder = new ViewHolder(new WheelViewItem(context, tv));
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(ViewHolder holder, int position) {
        Contact contact = mContacts.get(position);
        if(contact!=null) {
            holder.name.setText(contact.getName());
        }

        //        tv.setTextColor(unselectedTextColor);
        holder.name.setTextSize(textSize);
        holder.name.setGravity(Gravity.CENTER_VERTICAL);

        if(contact.isSelected){
            holder.name.setTextColor(selectedTextColor);
        }else{
            holder.name.setTextColor(unselectedTextColor);
        }
    }


    @Override
    public int getItemCount() {
        return mContacts.size();
    }

    public void clearItem(){
        mContacts.clear();
    }
    public void addItem(Contact contact){
        mContacts.add(contact);
    }
    public Contact getItem(int position) {
        if(position>= 0 && position < mContacts.size()) {
            return mContacts.get(position);
        }
        else {
            return null;
        }
    }


    public void setSelectedTextColor(int selectedTextColor) {
        this.selectedTextColor = selectedTextColor;
    }

    public void setUnselectedTextColor(int unselectedTextColor) {
        this.unselectedTextColor = unselectedTextColor;
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {
        public static String TAG_NAME = "view_holder_tag_name";
        public TextView name;
        public ViewHolder(View itemView) {
            super(itemView);
            name = (TextView) itemView.findViewWithTag(TAG_NAME);
        }
    }


    public static class Contact {
        private String mName;
        private boolean isSelected;
        public Contact(String name) {
            this.mName = name;
            this.isSelected = false;
        }
        public Contact(String name, boolean isSelected) {
            this.mName = name;
            this.isSelected = isSelected;
        }

        public void setSelected(boolean selected) {
            isSelected = selected;
        }

        public boolean isSelected() {
            return isSelected;
        }

        public String getName() {
            return mName;
        }


        private  int lastContactId = 0;

        public static ArrayList<Contact> createContactsList(int numContacts) {
            ArrayList<Contact> contacts = new ArrayList<Contact>();

            for (int i = 1; i <= numContacts; i++) {
                contacts.add(new Contact("Item : " + i,false));
            }

            return contacts;
        }
    }

    @Override
    public long getItemId(int position) {
        return position;
    }
}
