package zeiss.gesture.detector;

import android.view.MotionEvent;
import android.view.View;

import zeiss.gesture.callback.ZeissGestureSystemCallBack;
import zeiss.gesture.listener.ZeissTouchGestureListener;
import zeiss.gesture.listener.ZeissScaleGestureListener;

/**
 * Created by dennis on 13/9/16.
 */
public class ZeissGestureDetector {
    private ZeissGestureTouchDetector mZeissGestureTouchDetector;
    private ZeissGestureScaleDetector mZeissGestureScaleDetector;

    private ZeissTouchGestureListener gestureListener;
    private ZeissScaleGestureListener scaleGestureListener;

    public ZeissGestureDetector(View view, ZeissGestureSystemCallBack systemCallBack) {
        gestureListener = new ZeissTouchGestureListener(view,systemCallBack);
        mZeissGestureTouchDetector = new ZeissGestureTouchDetector(view.getContext(),gestureListener);

        scaleGestureListener = new ZeissScaleGestureListener();
        mZeissGestureScaleDetector = new ZeissGestureScaleDetector(view.getContext(),scaleGestureListener);

    }
    public ZeissGestureTouchDetector getZeissGestureTouchDetector() {
        return mZeissGestureTouchDetector;
    }

    public void setZeissGestureTouchDetector(ZeissGestureTouchDetector mZeissGestureTouchDetector) {
        this.mZeissGestureTouchDetector = mZeissGestureTouchDetector;
    }

    public ZeissGestureScaleDetector getZeissGestureScaleDetector() {
        return mZeissGestureScaleDetector;
    }

    public void setZeissGestureScaleDetector(ZeissGestureScaleDetector mZeissGestureScaleDetector) {
        this.mZeissGestureScaleDetector = mZeissGestureScaleDetector;
    }

    public void onTouchEvent(MotionEvent ev){
        if(mZeissGestureTouchDetector !=null)
            mZeissGestureTouchDetector.onTouchEvent(ev);
        if(mZeissGestureScaleDetector !=null)
            mZeissGestureScaleDetector.onTouchEvent(ev);
    }




}
