package zeiss.gesture.detector;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;

import zeiss.gesture.callback.ZeissGestureSystemCallBack;
import zeiss.gesture.listener.ZeissTouchGestureListener;

/**
 * Created by dennis on 13/9/16.
 */
public class ZeissGestureTouchDetector extends GestureDetector{
    ZeissTouchGestureListener mListener;

    public ZeissGestureTouchDetector(Context context, ZeissTouchGestureListener listener) {
        super(context, listener);
        mListener = listener;
    }
    public ZeissTouchGestureListener getZeissTouchGestureListener() {
        return mListener;
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        boolean consume = (mListener != null)? mListener.onTouchEvent(ev) : false;
        return consume || super.onTouchEvent(ev);
    }

    public interface OnSwipeListener {
        void onSwipeRight();
        void onSwipeLeft();
        void onSwipeUp();
        void onSwipeDown();
    }
    public interface OnTapListener {
        void onTapEvent(int finger, MotionEvent motionEvent);
        void onDoubleTap(int finger, MotionEvent motionEvent);
        void onTripleTap(int finger, MotionEvent motionEvent);
    }
    public interface OnLongPressListener {
        void onLongPress(int finger, MotionEvent motionEvent);
    }

    public interface OnScrollListener {
        void onStart(MotionEvent motionEvent);
        /**
         * @param motionEvent point1
         * @param motionEvent1 point2
         * @param distanceX distanceX
         * @param distanceY dinstanceY
         * @param isDrag isDrag
         */
        void onMove(MotionEvent motionEvent, MotionEvent motionEvent1, float distanceX, float distanceY, boolean isDrag);

        void onMoveEnd(MotionEvent motionEvent);

        void onFling(MotionEvent motionEvent, MotionEvent motionEvent1, float velocityX, float velocitY);
    }
    public interface OnTouchListener {
        boolean onTouchEvent(MotionEvent motionEvent);
    }

    public static class SystemGestureListener extends SimpleGestureListener{

        private  ZeissGestureTouchDetector.OnTapListener mSystemOnTapListener;
        private ZeissGestureTouchDetector.OnLongPressListener mSystemOnLongPressListener;
        private ZeissGestureSystemCallBack mSystemCallBack;
        private View  mainView;
        public SystemGestureListener(final View view, ZeissGestureSystemCallBack systemCallBack) {
            super(view);
            mainView = view;
            mSystemCallBack = systemCallBack;
            attachSystemListener();
            attachListener();
        }

        public void setSystemCallBack(ZeissGestureSystemCallBack systemCallBack) {
            mSystemCallBack = systemCallBack;
        }
        private void attachListener(){
            setOnTapListener(null);
            setOnLongPressListener(null);
        }
        private void attachSystemListener() {
            mSystemOnTapListener = new OnTapListener() {
                @Override
                public void onTapEvent(int finger, MotionEvent motionEvent) {

                }

                @Override
                public void onDoubleTap(int finger, MotionEvent motionEvent) {
                    if (mSystemCallBack != null) {
                        if (finger == 2) {
                            mSystemCallBack.onBackPress();
                        }
                    }
                }

                @Override
                public void onTripleTap(int finger, MotionEvent motionEvent) {

                }
            };
            mSystemOnLongPressListener = new OnLongPressListener() {
                @Override
                public void onLongPress(int finger, MotionEvent motionEvent) {
                    if (mSystemCallBack != null) {
                        if (finger == 1) {
                            mSystemCallBack.onMenuPress();
                        } else if (finger == 2) {
                            mSystemCallBack.onHomePress();
                        }

                    }
                }
            };
        }
        @Override
        public void setOnLongPressListener(final OnLongPressListener longPressListener) {
            mOnLongPressListener = new OnLongPressListener() {
                @Override
                public void onLongPress(int finger, MotionEvent motionEvent) {
                    mSystemOnLongPressListener.onLongPress(finger,motionEvent);

                    if(longPressListener!=null)
                    longPressListener.onLongPress(finger,motionEvent);

                    if (mSystemCallBack != null) {
                        if(finger == 2){
                            mSystemCallBack.onSuperMenuPress();
                        }
                    }
                }
            };
        }

        @Override
        public void setOnTapListener(final ZeissGestureTouchDetector.OnTapListener tapListener) {
            this.mOnTapListener = new OnTapListener() {
                @Override
                public void onTapEvent(int finger, MotionEvent motionEvent) {
                    mSystemOnTapListener.onTapEvent(finger,motionEvent);
                    if(tapListener!=null)
                    tapListener.onTapEvent(finger,motionEvent);
                }

                @Override
                public void onDoubleTap(int finger, MotionEvent motionEvent) {
                    mSystemOnTapListener.onDoubleTap(finger,motionEvent);
                    if(tapListener!=null)
                    tapListener.onDoubleTap(finger,motionEvent);
                }

                @Override
                public void onTripleTap(int finger, MotionEvent motionEvent) {
                    mSystemOnTapListener.onTripleTap(finger,motionEvent);
                    if(tapListener!=null)
                    tapListener.onTripleTap(finger,motionEvent);
                }
            };
        }
    }
    public static class SimpleGestureListener{
        protected View mView;
        protected ZeissGestureTouchDetector.OnSwipeListener mOnSwipeListener;
        protected ZeissGestureTouchDetector.OnTapListener mOnTapListener;
        protected ZeissGestureTouchDetector.OnLongPressListener mOnLongPressListener;
        protected ZeissGestureTouchDetector.OnScrollListener mOnScrollListener;
        protected ZeissGestureTouchDetector.OnTouchListener mOnTouchListener;
        public SimpleGestureListener(View view) {
            this.mView = view;
        }
        public void setOnSwipeListener(ZeissGestureTouchDetector.OnSwipeListener mOnSwipeListener) {
            this.mOnSwipeListener = mOnSwipeListener;
        }

        public void setOnTapListener(ZeissGestureTouchDetector.OnTapListener mOnTapListener) {
            this.mOnTapListener = mOnTapListener;
        }

        public void setOnLongPressListener(ZeissGestureTouchDetector.OnLongPressListener mOnLongPressListener) {
            this.mOnLongPressListener = mOnLongPressListener;
        }

        public void setOnScrollListener(ZeissGestureTouchDetector.OnScrollListener mOnScrollListener) {
            this.mOnScrollListener = mOnScrollListener;
        }

        public ZeissGestureTouchDetector.OnSwipeListener getOnSwipeListener() {
            return mOnSwipeListener;
        }

        public ZeissGestureTouchDetector.OnTapListener getOnTapListener() {
            return mOnTapListener;
        }

        public ZeissGestureTouchDetector.OnLongPressListener getOnLongPressListener() {
            return mOnLongPressListener;
        }

        public ZeissGestureTouchDetector.OnTouchListener getOnTouchListener() {
            return mOnTouchListener;
        }

        public void setOnTouchListener(ZeissGestureTouchDetector.OnTouchListener mTouchListener) {
            this.mOnTouchListener = mTouchListener;
        }

        //    public OnScaleListener getOnScaleListener() {
//        return mOnScaleListener;
//    }

        public ZeissGestureTouchDetector.OnScrollListener getOnScrollListener() {
            return mOnScrollListener;
        }
    }
}
