package zeiss.gesture.hardware;

import android.util.Log;
import android.view.KeyEvent;

import zeiss.gesture.Util;

/**
 * Created by dennis on 3/10/16.
 */
public class KeyCodeHelper {
    private static String Tag = KeyCodeHelper.class.getSimpleName();
    public enum KeyType{
        CONFIRM,CONFIRM_ACTION_UP,MENU_ACTION_UP,MENU,IGNORE,UNKNOWN,BACK,BACK_ACTION_UP,RIGHT_DOWN,LEFT_UP,RIGHT_DOWN_ACTION_UP,LEFT_UP_ACTION_UP
    }
    private static  void Log(String msg){
        if(Util.DEBUG) {
            Log.i(Tag, msg);
        }
    }

    public static void DisableVolumeControl(boolean isDisable) {
        //DisableVolumeControl
    }

    public static KeyType CheckKeyType(KeyEvent keyEvent) {
        return CheckKeyType(keyEvent.getKeyCode(),keyEvent);
    }
    /**
     * override dispatchKeyEvent call this function to check keycode
     * @param keyCode
     * @param keyEvent
     * @return
     */
    public static KeyType CheckKeyType(int keyCode, KeyEvent keyEvent) {
        Log("keyCode = "+keyCode+" keyEvent.repeatCount =  "+keyEvent.getRepeatCount()+" action = "+keyEvent.getAction()+" flag = "+keyEvent.getFlags()+" deviceid = "+keyEvent.getDeviceId());
        //********************************************//
        //Avoid repeat keycode//
        //********************************************//
        if(isRepeatAction(keyEvent)){
            Log("isRepeatAction : true");
            return KeyType.IGNORE;
        }
        //correct key flags 8
        if(keyEvent.getFlags() == 8) {
            if(keyEvent.getAction() == KeyEvent.ACTION_DOWN){
                //forward button is pressed
                if ((keyEvent.getKeyCode() == KeyEvent.KEYCODE_DPAD_RIGHT || keyEvent.getKeyCode() == KeyEvent.KEYCODE_VOLUME_DOWN)) {
                    return KeyType.RIGHT_DOWN;
                }

                //backward button is pressed
                else if ((keyEvent.getKeyCode() == KeyEvent.KEYCODE_DPAD_LEFT || keyEvent.getKeyCode() == KeyEvent.KEYCODE_VOLUME_UP) && keyEvent.getAction() == KeyEvent.ACTION_DOWN) {
                    return KeyType.LEFT_UP;
                }

                //confirm button is pressed
                else if (keyEvent.getKeyCode() == KeyEvent.KEYCODE_ENTER) {
                    return KeyType.CONFIRM;
                }
            }else if(keyEvent.getAction() == KeyEvent.ACTION_UP){
                if ((keyEvent.getKeyCode() == KeyEvent.KEYCODE_DPAD_RIGHT || keyEvent.getKeyCode() == KeyEvent.KEYCODE_VOLUME_DOWN)) {
                    return KeyType.RIGHT_DOWN_ACTION_UP;
                }

                //backward button is pressed
                else if ((keyEvent.getKeyCode() == KeyEvent.KEYCODE_DPAD_LEFT || keyEvent.getKeyCode() == KeyEvent.KEYCODE_VOLUME_UP)) {
                    return KeyType.LEFT_UP_ACTION_UP;
                }

                //confirm button is pressed
                else if (keyEvent.getKeyCode() == KeyEvent.KEYCODE_ENTER) {
                    return KeyType.CONFIRM_ACTION_UP;
                }
            }

        }else if(keyEvent.getFlags() == 0){
            //menu button is pressed
            if(keyEvent.getAction() == KeyEvent.ACTION_DOWN){
                if (keyEvent.getKeyCode() == KeyEvent.KEYCODE_MENU ) {
                    return KeyType.MENU;
                }else if(keyEvent.getKeyCode() == KeyEvent.KEYCODE_BACK) {
                    return KeyType.BACK;
                }
            }else if(keyEvent.getAction() == KeyEvent.ACTION_UP){
                if (keyEvent.getKeyCode() == KeyEvent.KEYCODE_MENU ) {
                    return KeyType.MENU_ACTION_UP;
                }else if(keyEvent.getKeyCode() == KeyEvent.KEYCODE_BACK) {
                    return KeyType.BACK_ACTION_UP;
                }
            }
        }
    return KeyType.UNKNOWN;
}

    private static boolean isRepeatAction(KeyEvent keyEvent){
        if(keyEvent.getRepeatCount() > 0){
            return true;
        }
        return false;
    }
}
