package zeiss.gesture.statusbar;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.BatteryManager;

/**
 * Created by dennis on 9/5/2017.
 */
public class BatteryReceiver extends BroadcastReceiver {
    public interface BatteryReceiverCallback {
        void onBatteryReceiver(BATTERY_STATUS status, float battery_level);
    }
    public enum BATTERY_STATUS {
        IS_CHARGE,
        IS_FULL,
        IS_DISCHARGE,
        UNKNOWN;
    }
    private BatteryReceiverCallback mCallback;
    private BATTERY_STATUS pre_Status;
    private float pre_Level;

    public BatteryReceiver(BatteryReceiverCallback callback) {
        this.mCallback = callback;
        pre_Status = BATTERY_STATUS.UNKNOWN;
        pre_Level = 0f;
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        int status = intent.getIntExtra(BatteryManager.EXTRA_STATUS, -1);
        boolean isCharging = status == BatteryManager.BATTERY_STATUS_CHARGING ||
                status == BatteryManager.BATTERY_STATUS_FULL;

        int chargePlug = intent.getIntExtra(BatteryManager.EXTRA_PLUGGED, -1);
        boolean usbCharge = chargePlug == BatteryManager.BATTERY_PLUGGED_USB;
        boolean acCharge = chargePlug == BatteryManager.BATTERY_PLUGGED_AC;

        int level = intent.getIntExtra(BatteryManager.EXTRA_LEVEL, -1);
        int scale = intent.getIntExtra(BatteryManager.EXTRA_SCALE, -1);

        float batteryPct = level / (float) scale;

        BATTERY_STATUS bStatus;

        if (isCharging) {
            if (batteryPct == 1f) {
                bStatus = BATTERY_STATUS.IS_FULL;
            } else {
                bStatus = BATTERY_STATUS.IS_CHARGE;
            }
        } else {
            bStatus = BATTERY_STATUS.IS_DISCHARGE;
        }

        if(mCallback != null){
            if(pre_Status != bStatus
                    || pre_Level != batteryPct) {
                pre_Status = bStatus;
                pre_Level = batteryPct;
                mCallback.onBatteryReceiver(bStatus, batteryPct);
            }
        }
    }

    public IntentFilter getFilter(){
        IntentFilter filter = new IntentFilter();
        filter.addAction(Intent.ACTION_BATTERY_CHANGED);
        filter.addAction(Intent.ACTION_BATTERY_LOW);
        filter.addAction(Intent.ACTION_BATTERY_OKAY);
        return filter;
    }
}