package zeiss.gesture.statusbar;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.TextClock;
import android.widget.TextView;

/**
 * Created by dennis on 25/4/2017.
 */
public class StatusBarAppView extends StatusBarView<StatusBarApp> {
    private StatusBarApp mStatusBar;
    private StatusBarApp.AppHolder holder;
    public StatusBarAppView(Context context) {
        super(context);
    }

    public StatusBarAppView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public StatusBarAppView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public StatusBarAppView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public void init(Context context) {
        mStatusBar = new StatusBarApp(context);
        holder = mStatusBar.getHolder();
        addView(mStatusBar.getRootView());
    }

    @Override
    public StatusBarApp getStatusBar() {
        return mStatusBar;
    }

    public void onResume(){
        if(holder!=null)
        holder.onResume();
    }


    public void onPause() {
        if(holder!=null)
        holder.onPause();
    }

}
