package zeiss.gesture.statusbar;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;

import zeiss.gesture.R;


/**
 * Created by dennis on 25/4/2017.
 */
public class StatusBarLauncher extends BaseStatusBar<StatusBarLauncher.LauncherHolder> {
    private String TAG = StatusBarLauncher.class.getName();

    private LauncherHolder mLauncherHolder;

    public StatusBarLauncher(Context context) {
        super(context);

    }

    @Override
    public void onCreateView(View view) {
        mLauncherHolder = new LauncherHolder(getRootView());
        super.onCreateView(view);



    }

    @Override
    public void fillContent() {

    }

    @Override
    public void setValue() {
        mLauncherHolder.defaultLayout();
    }

    @Override
    public LauncherHolder getHolder() {
        return mLauncherHolder;
    }

    @Override
    public int getLayoutId() {
        return R.layout.custom_status_bar_launcher;
    }

    private BroadcastReceiver batteryReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive( Context context, Intent intent )
        {
            int level = intent.getIntExtra( "level", 0 );
            String bat= String.valueOf(level) + "%" ;
            Log.i(TAG,"BAT = "+bat);
        }
    };



    public static class LauncherHolder extends StatusBarApp.AppHolder implements IStatusBar.LauncherView{
        public enum Item{
            BATTERY_STATUS,
            WIFI_STATUS,
            PHONE_CONNECT_STATUS
        }

        ImageView battery;
        ImageView wifi;
        ImageView phoneConnect;
        ProgressBar batteryProgressBar;
        BatteryReceiver mBatteryReceiver;
        View mView;

        public LauncherHolder(View view){
            super(view);
            mView = view;
            battery = (ImageView) view.findViewById(R.id.battery);
            wifi = (ImageView) view.findViewById(R.id.wifi);
            phoneConnect = (ImageView) view.findViewById(R.id.phone_connect);
            batteryProgressBar = (ProgressBar) view.findViewById(R.id.batteryProgressBar);


            mBatteryReceiver = new BatteryReceiver(new BatteryReceiver.BatteryReceiverCallback() {
                @Override
                public void onBatteryReceiver(BatteryReceiver.BATTERY_STATUS status, float battery_level) {
                    if(batteryProgressBar!=null) {
                        batteryProgressBar.setProgress((int) (battery_level * 100));
                    }
                }
            });

        }
        @Override
        public ImageView getBattery() {
            return battery;
        }
        @Override
        public ImageView getWifi() {
            return wifi;
        }
        @Override
        public ImageView getPhoneConnect() {
            return phoneConnect;
        }

        public ProgressBar getBatteryProgressBar() {
            return batteryProgressBar;
        }

        @Override
        public void setItemSize(int height, int width){
            getBattery().setLayoutParams(new LinearLayout.LayoutParams(height,width));
            getWifi().setLayoutParams(new LinearLayout.LayoutParams(height,width));
            getPhoneConnect().setLayoutParams(new LinearLayout.LayoutParams(height,width));
        }

        @Override
        public void defaultLayout(){
            Log.d("Dennis","LauncherView -- defaultLayout");
            getBattery().setVisibility(View.GONE);
            getBatteryProgressBar().setVisibility(View.VISIBLE);

            getWifi().setVisibility(View.GONE);
            getPhoneConnect().setVisibility(View.GONE);
            getTitle().setVisibility(View.GONE);
            getTimeClock().setVisibility(View.VISIBLE);
        }

        @Override
        public void displayItem(boolean isShow){
            super.displayItem(isShow);
            getBattery().setVisibility(isShow ? View.VISIBLE :View.GONE);
            getBatteryProgressBar().setVisibility(View.GONE);
            getWifi().setVisibility(isShow ? View.VISIBLE :View.GONE);
            getPhoneConnect().setVisibility(isShow ? View.VISIBLE :View.GONE);
        }


        @Override
        public void showItem(Item item, boolean isShow){
            switch (item){

                case BATTERY_STATUS:
//                  getBattery().setVisibility(isShow ? View.VISIBLE :View.GONE);
                    getBatteryProgressBar().setVisibility(isShow ? View.VISIBLE :View.GONE);
                    break;
                case WIFI_STATUS:
                    getWifi().setVisibility(isShow ? View.VISIBLE :View.GONE);
                    break;
                case PHONE_CONNECT_STATUS:
                    getPhoneConnect().setVisibility(isShow ? View.VISIBLE :View.GONE);
                    break;
            }
        }

        @Override
        public void onResume() {
            super.onResume();
            if(mView!=null&& mBatteryReceiver!=null)
            mView.getContext().registerReceiver(mBatteryReceiver,mBatteryReceiver.getFilter());

        }

        @Override
        public void onPause() {
            super.onPause();
            if(mView!=null&& mBatteryReceiver!=null)
            mView.getContext().unregisterReceiver(mBatteryReceiver);
        }


    }
}
