package zeiss.gesture.view;

import android.app.Instrumentation;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;

import zeiss.gesture.Util;
import zeiss.gesture.callback.ZeissGestureSystemCallBack;
import zeiss.gesture.detector.ZeissGestureDetector;
import zeiss.gesture.listener.ZeissScaleGestureListener;
import zeiss.gesture.listener.ZeissTouchGestureListener;

/**
 * Created by Flame on 19/7/16.
 */
public class ZeissGestureView extends View implements View.OnTouchListener,ZeissGestureSystemCallBack {
    /**
     *
     *
     *  i.e.
     *  <pre>
     *   {@code
     *   public void init(){
     *       ZeissGestureView gestureView = new ZeissGestureView(getContext());
     *       attachTouchEventListener(gestureView);
     *       attachScaleEventListener(gestureView);
     *      }
     *  private void attachScaleEventListener(MADGestureView gestureView){
     *      ZeissScaleGestureListener scaleListener = gestureView.getScaleGestureListener();
     *      scaleListener.setOnScaleListener(new ZeissGestureScaleDetector.OnScaleListener() {
     *       @Override
     *       public void onScaleGesture(ScaleGestureDetector detector, float scaleFactor) {
     *
     *           }
     *          });
     *   }
     *   private void attachTouchEventListener(MADGestureView gestureView){
     *   }
     *
     *   }
     *  </pre>

     */
    private static final String TAG = ZeissGestureView.class.getSimpleName();
    private ZeissGestureDetector mZeissGestureDetector;

    public ZeissGestureView(Context context) {
        super(context);
        init(context);
    }
    public ZeissGestureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }
    public ZeissGestureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private void init(Context context){
        Util.EnableSystemGesture(context,true);
        mZeissGestureDetector = new ZeissGestureDetector(this,this);
        attacthEventListener();
    }

    public void attacthEventListener(){
        commit();
    }

    public void commit(){
        setOnTouchListener(this);
    }

    public ZeissTouchGestureListener getGestureListener(){
        return mZeissGestureDetector.getZeissGestureTouchDetector().getZeissTouchGestureListener();
    }
    public ZeissScaleGestureListener getScaleGestureListener(){
        return mZeissGestureDetector.getZeissGestureScaleDetector().getZeissScaleGestureListener();
    }

    private void Log(String msg){
        if(Util.DEBUG) {Log.i(TAG,""+msg);}
    }

    @Override
    public boolean onTouch(View view, MotionEvent motionEvent) {
        mZeissGestureDetector.onTouchEvent(motionEvent);
        return true;
    }

    public static void sendKeyEvent(Context context,final int keyCode){
        if(keyCode == KeyEvent.KEYCODE_HOME){
            if(context!=null) {
                Intent intent = new Intent();
                intent.setAction(Intent.ACTION_MAIN);
                intent.addCategory(Intent.CATEGORY_HOME);
                context.startActivity(intent);
            }
        }else if(keyCode == KeyEvent.KEYCODE_MEDIA_TOP_MENU){
            if(context!=null) {

                if(Util.AppInstalledOrNot(context,"madgaze.g200.supermenu")) {
                    Intent intent = new Intent();
                    intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    ComponentName comp = new ComponentName("madgaze.g200.supermenu", "madgaze.g200.supermenu.MainActivity");
                    // ComponentName comp = new ComponentName("com.android.settings","com.android.settings.Settings");
                    intent.setComponent(comp);
                    context.startActivity(intent);
                }
            }
        }

        else {
            new Thread(new Runnable() {
                @Override
                public void run() {
                    try {
                        Instrumentation inst = new Instrumentation();
                        inst.sendKeyDownUpSync(keyCode);
                    } catch (Exception exception) {
                        Log.e("sendKeyEvent","Exception = " + exception.toString());
                    }

                }
            }).start();
        }
    }
    @Override
    public void onBackPress() {
//        if(getContext()!=null){
//            ((Activity) getContext()).dispatchKeyEvent(new KeyEvent(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_BACK));
//            ((Activity) getContext()).dispatchKeyEvent(new KeyEvent(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_BACK));
//        }
        sendKeyEvent(getContext(),KeyEvent.KEYCODE_BACK);
    }

    @Override
    public void onHomePress() {
//        ((Activity) getContext()).dispatchKeyEvent(new KeyEvent(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_HOME));
//        ((Activity) getContext()).dispatchKeyEvent(new KeyEvent(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_HOME));
        sendKeyEvent(getContext(),KeyEvent.KEYCODE_HOME);
    }

    @Override
    public void onMenuPress() {
//        if(getContext()!=null) {
//            ((Activity) getContext()).openOptionsMenu();
//        }
        sendKeyEvent(getContext(),KeyEvent.KEYCODE_MENU);
    }

    @Override
    public void onSuperMenuPress() {
        sendKeyEvent(getContext(),KeyEvent.KEYCODE_MEDIA_TOP_MENU);
    }



}
