/*
 * Decompiled with CFR 0.152.
 */
package zlc.season.rxroutercompiler;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import zlc.season.rxrouterannotation.Provider;
import zlc.season.rxrouterannotation.Router;
import zlc.season.rxrouterannotation.Url;

public class AnnotationProcess
extends AbstractProcessor {
    private Messager messager;
    private Elements elementUtils;
    private Filer filer;
    private int moduleAnnotationSize = 0;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.messager = this.processingEnv.getMessager();
        this.elementUtils = this.processingEnv.getElementUtils();
        this.filer = this.processingEnv.getFiler();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.add(Url.class.getCanonicalName());
        return types;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Set<? extends Element> urlAnnotations = roundEnvironment.getElementsAnnotatedWith(Url.class);
        Set<? extends Element> moduleAnnotations = roundEnvironment.getElementsAnnotatedWith(Router.class);
        this.moduleAnnotationSize += moduleAnnotations.size();
        for (Element element : moduleAnnotations) {
            String packageName = this.elementUtils.getPackageOf(element).getQualifiedName().toString();
            try {
                this.generateRoutingTable(packageName, element.getSimpleName().toString(), urlAnnotations);
            }
            catch (IOException e) {
                this.printError(e.getMessage());
            }
        }
        if (roundEnvironment.processingOver() && this.moduleAnnotationSize == 0) {
            this.printError("You need to add a class that is annotated by @Router to your module!");
        }
        return true;
    }

    private void generateRoutingTable(String packageName, String className, Set<? extends Element> urlAnnotations) throws IOException {
        ParameterizedTypeName classWithWildcard = ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
        ParameterizedTypeName hashMap = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get(String.class), classWithWildcard});
        FieldSpec routerTable = FieldSpec.builder((TypeName)hashMap, (String)"table", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer(CodeBlock.builder().add("new $T<>()", new Object[]{ClassName.get(HashMap.class)}).build()).build();
        CodeBlock.Builder staticBlock = CodeBlock.builder();
        for (Element element : urlAnnotations) {
            TypeElement typeElement = (TypeElement)element;
            ClassName activity = ClassName.get((TypeElement)typeElement);
            String url = element.getAnnotation(Url.class).value();
            staticBlock.add("table.put($S,$T.class);\n", new Object[]{url, activity});
        }
        MethodSpec provideMethod = MethodSpec.methodBuilder((String)"provide").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Override.class).build()).addParameter(String.class, "url", new Modifier[0]).returns((TypeName)classWithWildcard).addStatement("return table.get(url)", new Object[0]).build();
        TypeSpec typeSpec = TypeSpec.classBuilder((String)(className + "Provider")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)ClassName.get(Provider.class)).addField(routerTable).addStaticBlock(staticBlock.build()).addMethod(provideMethod).build();
        JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build().writeTo(this.filer);
    }

    private void printError(String message) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, message);
    }

    private void printWaring(String waring) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, waring);
    }
}

